@extends('admin.main')
@section('content')

          <div class="row">
              <div class="col-12">
                  <div class="row">
                    @foreach ($homes as $home)
                    <div class="col-12 mb-4" id="sec8">
                        <div class="card border-0 shadow">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h2 class="fs-5 fw-bold mb-0">{{$home->heading}}</h2>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                              <div class="row">
                                  <div class="col-5">
                                      <img src="{{asset('uploads/'.$home->image)}}" alt="">
                                  </div>
                                  <div class="col-7">
                                      <form action="{{url('home_content/about')}}/{{$home->id}}" method="post" enctype="multipart/form-data">
                                          @csrf
                                          <input type="text" class="form-control mb-3" placeholder="Heading" name="heading" value="{{$home->heading}}" required>
                                          <textarea name="content" class="form-control mb-3 contents_textarea" id="content{{$home->id}}" >{{$home->content}}</textarea>
                                          <input type="file" class="form-control mb-3 mt-3" name="image">
                                          <div class="text-end">
                                          <button class="btn btn-secondary text-dark btn-sm me-2" type="submit">Update Section</button>
                                      </div>
                                      </form>
                                  </div>
                              </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                  </div>
              </div>
              
          </div>
          @endsection
          