@extends('admin.main')
@section('content')
@php
use Illuminate\Support\Facades\Crypt;
@endphp
    <style>
        .btn-check:checked+.btn-secondary,
        .btn-check:active+.btn-secondary,
        .btn-secondary:active,
        .btn-secondary.active,
        .show>.btn-secondary.dropdown-toggle {
            background-color: rgba(var(--bs-gray-800-rgb), var(--bs-bg-opacity)) !important;
            border-color: rgba(var(--bs-gray-800-rgb), var(--bs-bg-opacity)) !important;
            color: #fff;
        }
        #userforaccess .table-responsive {
            filter: blur(5px);
            user-select: none;
            pointer-events: none
        }
        #userforaccess span#cofsb {
            position: absolute;
            top: 25px;
            left: 30%;
            font-size: 25px;
            font-weight: 500;
        }
        .removeAccess{
            cursor: pointer;
        }
        .removeAccess:hover svg circle{
            fill: #000000;
        }
        .removeAccess:hover svg path{
            fill: #d6e3ff;
        }
    </style>
    <div class="row">
        @if(session('userid') == 1)
        <div class="col-5 mb-4">
            <div class="card bg-yellow-100 border-0 shadow mb-4">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h2 class="fs-2 fw-bold mb-0"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="40" height="40" x="0" y="0" viewBox="0 0 48 48" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><g id="Open_Folder-2" data-name="Open Folder"><path d="m45 18h-4v-4a2.996 2.996 0 0 0 -3-3h-15.25a2.9991 2.9991 0 0 1 -2.33-1.11l-1.96-2.41a3.9846 3.9846 0 0 0 -3.1-1.48h-11.36a2.996 2.996 0 0 0 -3 3v29.57a3.3672 3.3672 0 0 0 1.01 2.42 3.3672 3.3672 0 0 0 2.42 1.01h33.66a3.441 3.441 0 0 0 3.3-2.47l5.53-18.97a2.003 2.003 0 0 0 -1.92-2.56z" fill="#376cfb" data-original="#376cfb" class=""></path><path d="m44.9987 18h-28.4262a3.43 3.43 0 0 0 -3.2925 2.47l-5.56 19.0614a3.4286 3.4286 0 0 1 -3.2914 2.4686h33.6638a3.43 3.43 0 0 0 3.2933-2.47l5.5331-18.97a2 2 0 0 0 -1.9201-2.56z" fill="#4294ff" data-original="#4294ff" class=""></path></g></g></svg> {{$folder_name}}</h2>
                        </div>
                    </div>
                </div>
                <div class="card-body p-4">
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush" id="driveDataList">
                            <thead class="thead-light">
                                <tr>
                                    <th class="border-bottom" scope="col">S NO.</th>
                                    <th class="border-bottom" scope="col">File Name</th>
                                    <th class="border-bottom" scope="col">View</th>
                                    <th class="border-bottom" scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-7 mb-4">
            <div class="card bg-yellow-100 border-0 shadow mb-4">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h2 class="fs-2 fw-bold mb-0 selectthesheet">Select the Sheet</h2>
                        </div>
                    </div>
                </div>
                <div class="card-body p-4 position-relative userforaccessclass" id="userforaccess">
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush accessxp">
                            <thead class="thead-light">
                                <tr>
                                    <th class="border-bottom" scope="col">ID</th>
                                    <th class="border-bottom" scope="col">Name</th>
                                    <th class="border-bottom" scope="col">Email</th>
                                    <th class="border-bottom" scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($users as $user)
                                    @if ($user->id != 1)
                                        <tr>
                                            <td class="uid">{{ $user->id }}</td>
                                            <td>{{ $user->name }}</td>
                                            <td>{{ $user->email }}</td>
                                            <td data-td="{{$user->id}}" class="forr_{{$user->id}}">
                                                <input type="radio" class="accessCheckbox btn-check btn btn-secondary text-dark btn-sm"
                                                    name="options_{{ $user->id }}" id="option1_{{ $user->id }}"
                                                    autocomplete="off" value="editor" data-user="{{$user->id}}">
                                                <label class="btn btn-secondary" data-user="{{$user->id}}"
                                                    for="option1_{{ $user->id }}">Editor</label>

                                                <input type="radio" class="accessCheckbox btn-check btn btn-secondary text-dark btn-sm"
                                                    name="options_{{ $user->id }}" id="option2_{{ $user->id }}"
                                                    autocomplete="off" value="insert" data-user="{{$user->id}}">
                                                <label class="btn btn-secondary" data-user="{{$user->id}}" for="option2_{{ $user->id }}">Insert
                                                    Only</label>

                                                <input type="radio" class="accessCheckbox btn-check btn btn-secondary text-dark btn-sm"
                                                    name="options_{{ $user->id }}" id="option4_{{ $user->id }}"
                                                    autocomplete="off" value="view" data-user="{{$user->id}}">
                                                <label class="btn btn-secondary" data-user="{{$user->id}}" for="option4_{{ $user->id }}">View
                                                    Only</label>
                                            </td>
                                        </tr>
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <span id="cofsb">Click On File Share Button</span>
                </div>
            </div>
        </div>
        @else
        <div class="col-6 mb-4">
            <div class="card bg-yellow-100 border-0 shadow mb-4">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h2 class="fs-2 fw-bold mb-0">Sheets</h2>
                            
                        </div>
                    </div>
                </div>
                <div class="card-body p-4">
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                                <tr>
                                    <th class="border-bottom" scope="col">S NO.</th>
                                    <th class="border-bottom" scope="col">File Name</th>
                                    <th class="border-bottom" scope="col">Role</th>
                                    <th class="border-bottom" scope="col">View</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($users as $user)
                                    <tr>
                                        <td class="uid">{{ $user->id }}</td>
                                        <td class="uid">
                                            <svg style="margin-right:10px" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="20" x="0" y="0" viewBox="0 0 510 510" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><linearGradient id="SVGID_1_" gradientUnits="userSpaceOnUse" x1="157.153" x2="399.748" y1="198.847" y2="441.441"><stop offset="0" stop-color="#7faef4"></stop><stop offset="1" stop-color="#4c8df1"></stop></linearGradient><linearGradient id="lg1"><stop offset="0" stop-color="#4c8df1" stop-opacity="0"></stop><stop offset="1" stop-color="#4256ac"></stop></linearGradient><linearGradient id="SVGID_2_" gradientUnits="userSpaceOnUse" x1="410.106" x2="371.606" xlink:href="#lg1" y1="173.728" y2="61.228"></linearGradient><linearGradient id="SVGID_3_" gradientUnits="userSpaceOnUse" x1="343.272" x2="387.993" y1="58.728" y2="103.45"><stop offset="0" stop-color="#a7c5fd"></stop><stop offset="1" stop-color="#7faef4"></stop></linearGradient><linearGradient id="SVGID_4_" gradientTransform="matrix(-1 0 0 1 1574 0)" gradientUnits="userSpaceOnUse" x1="1319" x2="1319" xlink:href="#lg1" y1="463.7" y2="513.288"></linearGradient><g><path d="m68.17 31.88v446.25c0 17.529 14.341 31.87 31.87 31.87h309.91c17.534 0 31.88-14.346 31.88-31.88v-360.725c0-9.787-3.888-19.173-10.808-26.094l-80.493-80.493c-6.921-6.92-16.307-10.808-26.094-10.808h-224.385c-17.534 0-31.88 14.346-31.88 31.88z" fill="url(#SVGID_1_)" data-original="url(#SVGID_1_)"></path><g><g><g><g><path d="m153.111 246.041h203.778c5.079 0 9.196-4.117 9.196-9.196v-22.425c0-5.079-4.117-9.196-9.196-9.196h-203.778c-5.079 0-9.196 4.117-9.196 9.196v22.425c0 5.079 4.117 9.196 9.196 9.196z" fill="#ebeff0" data-original="#ebeff0"></path></g></g></g><g><g><g><path d="m153.111 309.756h203.778c5.079 0 9.196-4.117 9.196-9.196v-22.425c0-5.079-4.117-9.196-9.196-9.196h-203.778c-5.079 0-9.196 4.117-9.196 9.196v22.425c0 5.079 4.117 9.196 9.196 9.196z" fill="#ebeff0" data-original="#ebeff0"></path></g></g></g><g><g><g><path d="m153.111 373.47h203.778c5.079 0 9.196-4.117 9.196-9.196v-22.424c0-5.079-4.117-9.196-9.196-9.196h-203.778c-5.079 0-9.196 4.117-9.196 9.196v22.425c0 5.078 4.117 9.195 9.196 9.195z" fill="#ebeff0" data-original="#ebeff0"></path></g></g></g><g><g><g><path d="m150.573 437.185h103.155c3.677 0 6.658-2.981 6.658-6.658v-27.5c0-3.677-2.981-6.658-6.658-6.658h-103.155c-3.677 0-6.658 2.981-6.658 6.658v27.5c0 3.677 2.981 6.658 6.658 6.658z" fill="#ebeff0" data-original="#ebeff0"></path></g></g></g></g><path d="m350.528 10.808c-4.74-4.74-10.638-8.056-17.028-9.676v103.922l108.33 108.33v-95.99c0-9.787-3.888-19.173-10.808-26.094z" fill="url(#SVGID_2_)" data-original="url(#SVGID_2_)"></path><path d="m440.737 108.443c.118.512.227 1.011.326 1.492h-97.648c-6.914 0-12.52-5.605-12.52-12.52v-96.834c.763.136 1.565.295 2.392.478 7.279 1.61 13.916 5.353 19.188 10.624l77.655 77.655c5.251 5.251 8.938 11.87 10.607 19.105z" fill="url(#SVGID_3_)" data-original="url(#SVGID_3_)"></path><path d="m441.83 447.201v30.919c0 17.534-14.346 31.88-31.88 31.88h-309.91c-17.529 0-31.87-14.342-31.87-31.87v-30.929z" fill="url(#SVGID_4_)" data-original="url(#SVGID_4_)"></path></g></g></svg>
                                            {{ $user->file_name }}</td>
                                        <td><span style="font-size: 13px;background: #223d7a;padding: 4px 8px;border-radius: 3px;color:#fff;">{{ucwords($user->role)}}</span></td>
                                        <td><a class="btn btn-secondary text-dark btn-sm me-2" href="{{ url('spreadsheets/'.Crypt::encryptString($user->file_id).'/'.$user->file_name) }}">Open</a></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
    <div class="row">
        <div class="col-12">
            <div class="row">
            </div>
        </div>
    </div>
    <script>
        const sheetId = "";
        @if(isset($folder_id))
        const folderID = "{{$folder_id}}";
        @endif
        
    </script>
@endsection
