@extends('admin.main')
@section('content')

          <div class="row">
            <div class="col-12 mb-4">
                <div class="card border-0 shadow">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col">
                                <h2 class="fs-5 fw-bold mb-0">Contacts</h2>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="border-bottom" scope="col">ID</th>
                                <th class="border-bottom" scope="col">Name</th>
                                <th class="border-bottom" scope="col">Email</th>
                                <th class="border-bottom" scope="col">Phone</th>
                                <th class="border-bottom" scope="col">Subject</th>
                                <th class="border-bottom" scope="col">Message</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach ($contacts as $contact)
                                <tr>
                                    <th class="text-gray-900" scope="row">
                                        {{$contact->id}}
                                    </th>
                                    <td class="fw-bolder text-gray-500">
                                        {{$contact->name}}
                                    </td>
                                    <td class="fw-bolder text-gray-500">
                                        {{$contact->email}}
                                    </td>
                                    <td class="fw-bolder text-gray-500">
                                        {{$contact->phone}}
                                    </td>
                                    <td class="fw-bolder text-gray-500">
                                        {{$contact->subject}}
                                    </td>
                                    <td class="fw-bolder text-gray-500" style="white-space: initial;">
                                        {{$contact->message}}
                                        
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
                  </div>
          @endsection
          