@extends('admin.main')
@section('content')
    <style>
        textarea::placeholder {
            color: rgba(54, 54, 54, 0.288) !important;
        }
        .input-group-text::placeholder{
            color: rgb(209, 209, 209);
        }
    </style>
    <div class="row justify-content-center">
        <div class="col-8">
            <div class="card bg-yellow-100 border-0 shadow mb-4">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h2 class="fs-2 fw-bold mb-0">Deploy URL <sup class="text-danger">*</sup><sup class="text-danger">{{Session::get('deploys_url')}}</sup></h2>
                        </div>
                    </div>
                </div>
                <div class="card-body p-4">
                    <form action="{{url('update-deploy-url')}}" method="POST">
                        @csrf
                        <div class="input-group mb-3">
                            <input type="text" class="form-control" aria-describedby="basic-addon2" placeholder="DEPLOY URL" name="deploys_url" required="" value="{{Session::has('deploys_url') ? Session::get('deploys_url') : $deploy}}" autocomplete="off">
                            @if(Session::has('deploys_url'))
                            <input type="text" class="input-group-text" id="basic-addon2" placeholder="DEPLOY-12345" name="deploys_otp" required="" value="" autocomplete="off">
                            @endif
                        </div>
                        <span class="text-danger">{{Session::get('url_updated')}}</span>
                            <div class="text-end">
                            <button class="btn btn-secondary text-dark btn-sm me-2" type="submit" onclick="if (confirm('Do you really want to change the Deploy URL?')){return true;}else{event.stopPropagation(); event.preventDefault();};">Update Deploy URL</button>
                        </div>
                        </form>
                </div>
            </div>
        </div>
    </div>
@endsection