@extends('admin.main')
@section('content')

          <div class="row">
            <div class="col-12 mb-4">
                <div class="card border-0 shadow">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col">
                                <h2 class="fs-5 fw-bold mb-0">{{$home[0]['heading']}}</h2>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                      <div class="row">
                          <div class="col-5">
                              <img src="{{asset('uploads/'.$home[0]['image'])}}" alt="">
                          </div>
                          <div class="col-7">
                              <form action="{{url('home_content/expertise')}}/{{$home[0]['id']}}" method="post" enctype="multipart/form-data">
                                  @csrf
                                  <input type="text" class="form-control mb-3" placeholder="Heading" name="heading" value="{{$home[0]['heading']}}" required>
                                  <textarea name="content" class="form-control mb-3 contents_textarea d-none" id="content" >{{$home[0]['content']}}</textarea>
                                  <input type="file" class="form-control mb-3 mt-3" name="image">
                                  <div class="text-end">
                                  <button class="btn btn-secondary text-dark btn-sm me-2" type="submit">Update Section</button>
                              </div>
                              </form>
                          </div>
                      </div>
                    </div>
                </div>
            </div>

            @foreach ($services as $service)
                    
            <div class="col-lg-4 col-md-6 col-12 mb-4" id="sec{{$service->id}}">
                <div class="card border-0 shadow">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col">
                                <h2 class="fs-5 fw-bold mb-0">{{$service->heading}}</h2>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                      <div class="col-12">
                          <img src="{{asset('uploads/'.$service->image)}}" alt="" class="mb-3 w-100 rounded">
                          <form action="{{url('dashboard/service-update/expertise')}}/{{$service->id}}" method="post" enctype="multipart/form-data">
                              @csrf
                              <input type="text" class="form-control mb-3" style="font-size: 25px; font-weight:500" placeholder="Heading" name="heading" value="{{$service->heading}}" required>
                              <textarea name="content" class="form-control mb-0 contents_textarea" id="content{{$service->id}}" >{{$service->content}}</textarea>
                              <input type="file" class="form-control mb-3 mt-3" name="image">
                              <div class="text-end">
                              <button class="btn btn-secondary text-dark btn-sm me-2" type="submit">Update Section</button>
                          </div>
                          </form>
                      </div>
                    </div>
                </div>
            </div>
            @endforeach
                  </div>

          @endsection
          