@extends('admin.main')
@section('content')
    <style>
        textarea::placeholder {
            color: rgba(54, 54, 54, 0.288) !important;
        }
    </style>
    <div class="row ">
        <div class="col-12">
            <div class="card bg-yellow-100 border-0 shadow mb-4">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h2 class="fs-2 fw-bold mb-0">Login History</h2>
                        </div>
                    </div>
                </div>
                <div class="card-body p-4">
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                                <tr>
                                    <th class="border-bottom" scope="col">User ID</th>
                                    <th class="border-bottom" scope="col">User Email</th>
                                    <th class="border-bottom" scope="col">Login From</th>
                                    <th class="border-bottom" scope="col">-></th>
                                    <th class="border-bottom" scope="col">Login To</th>
                                    <th class="border-bottom" scope="col">Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($login_histories as $history)
                                <tr>
                                    <td><b>#UID_{{$history->user_id}}</b></td>
                                    <td>{{$history->email}}</td>
                                    <td>{{$history->last_login}}</td>
                                    <td>-></td>
                                    <td>{{$history->last_logout}}</td>
                                    <td>{{$history->date}}</td>
                                </tr>
                                @endforeach
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    
    </div>
@endsection