@extends('admin.main')
@section('content')
    <style>
        textarea::placeholder {
            color: rgba(54, 54, 54, 0.288) !important;
        }
    </style>
    <div class="row ">
        <div class="col-9">
            <div class="card bg-yellow-100 border-0 shadow mb-4">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h2 class="fs-2 fw-bold mb-0">Users</h2>
                        </div>
                    </div>
                </div>
                <div class="card-body p-4">
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                                <tr>
                                    <th class="border-bottom" scope="col">ID</th>
                                    <th class="border-bottom" scope="col">Name</th>
                                    <th class="border-bottom" scope="col">Email</th>
                                    <th class="border-bottom" scope="col">Designation</th>
                                    <th class="border-bottom" scope="col">Department</th>
                                    <th class="border-bottom" scope="col">User Status</th>
                                    <th class="border-bottom text-center" scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($users as $user)
                                    @php $var = ''; @endphp
                                    @if (isset($edituser->id) && $edituser->id == $user->id)
                                        @php $var = 'background: #ffce89;'; @endphp
                                    @else
                                        @php $var = ''; @endphp
                                    @endif
                                    <tr style="{{ $var }}">
                                        <td>{{ $user->id }}</td>
                                        <td>{{ $user->name }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td>{{ $user->designation }}</td>
                                        <td>{{ $user->department }}</td>
                                        @if ($user->id != 1)
                                            <td class="text-center ">
                                                <div class="form-check form-switch d-inline-block">
                                                    <input class="form-check-input userUnableDisable" type="checkbox"
                                                        role="switch" name="ud_user" value="{{ $user->id }}"
                                                        {{ $user->status == 0 ? '' : 'checked' }}>
                                                </div>
                                            </td>
                                            <td class="text-center ">
                                                <a href="{{ url('edituser') . '/' . $user->id }}" class="me-3"><svg
                                                        xmlns="http://www.w3.org/2000/svg" version="1.1"
                                                        xmlns:xlink="http://www.w3.org/1999/xlink"
                                                        xmlns:svgjs="http://svgjs.com/svgjs" width="20" height="20"
                                                        x="0" y="0" viewBox="0 0 24 24"
                                                        style="enable-background:new 0 0 512 512" xml:space="preserve"
                                                        class="">
                                                        <g>
                                                            <path
                                                                d="m17 24h-14c-1.654 0-3-1.346-3-3v-14c0-1.654 1.346-3 3-3h8c.553 0 1 .448 1 1s-.447 1-1 1h-8c-.552 0-1 .449-1 1v14c0 .551.448 1 1 1h14c.552 0 1-.449 1-1v-8c0-.552.447-1 1-1s1 .448 1 1v8c0 1.654-1.346 3-3 3z"
                                                                fill="#607d8b" data-original="#607d8b" class="">
                                                            </path>
                                                            <path
                                                                d="m17.288 3.177-7.912 7.912c-.07.07-.117.159-.137.255l-.707 3.536c-.033.164.018.334.137.452.095.095.223.146.354.146l.098-.01 3.535-.707c.098-.019.186-.067.256-.137l7.912-7.912z"
                                                                fill="#42a5f5" data-original="#42a5f5"></path>
                                                            <path
                                                                d="m23.268.732c-.975-.975-2.561-.975-3.535 0l-1.384 1.384 3.535 3.535 1.384-1.384c.472-.471.732-1.099.732-1.767s-.26-1.296-.732-1.768z"
                                                                fill="#42a5f5" data-original="#42a5f5"></path>
                                                            <path
                                                                d="m19 12c-.553 0-1 .448-1 1v8c0 .551-.448 1-1 1h-14c-.276 0-.526-.112-.707-.293l-1.413 1.413c.543.544 1.293.88 2.12.88h14c1.654 0 3-1.346 3-3v-8c0-.553-.447-1-1-1z"
                                                                fill="#546d79" data-original="#546d79" class="">
                                                            </path>
                                                            <g fill="#3990d5">
                                                                <path
                                                                    d="m19.056 4.944-10.387 10.387c.095.095.223.146.354.146l.098-.01 3.535-.707c.098-.019.186-.067.256-.137l7.912-7.912z"
                                                                    fill="#3990d5" data-original="#3990d5"></path>
                                                                <path
                                                                    d="m23.268.732-3.151 3.151 1.768 1.768 1.384-1.384c.471-.471.731-1.099.731-1.767s-.26-1.296-.732-1.768z"
                                                                    fill="#3990d5" data-original="#3990d5"></path>
                                                            </g>
                                                        </g>
                                                    </svg></a>
                                                <a href="{{ 'remove_user/' . $user->id }}"
                                                    onclick="if (confirm('Remove {{ $user->name }}?')){return true;}else{event.stopPropagation(); event.preventDefault();};"
                                                    title="Remove {{ $user->name }}"><svg
                                                        xmlns="http://www.w3.org/2000/svg" version="1.1"
                                                        xmlns:xlink="http://www.w3.org/1999/xlink"
                                                        xmlns:svgjs="http://svgjs.com/svgjs" width="20" height="20"
                                                        x="0" y="0" viewBox="0 0 511.999 511.999"
                                                        style="enable-background:new 0 0 512 512" xml:space="preserve"
                                                        class="">
                                                        <g>
                                                            <g>
                                                                <path
                                                                    d="m329.308 50.75h-146.622v-27.213c0-12.998 10.537-23.536 23.536-23.536h99.55c12.998 0 23.536 10.537 23.536 23.536z"
                                                                    fill="#537983" data-original="#537983"></path>
                                                                <path
                                                                    d="m329.306 23.539v27.21h-24.37v-27.21c0-13-10.539-23.539-23.539-23.539h24.37c13 0 23.539 10.539 23.539 23.539z"
                                                                    fill="#426970" data-original="#426970"></path>
                                                                <path
                                                                    d="m422.678 87.128h-333.362v-25.152c0-8.749 7.092-15.841 15.841-15.841h301.682c8.749 0 15.841 7.092 15.841 15.841v25.152z"
                                                                    fill="#7ca1b1" data-original="#7ca1b1" class="">
                                                                </path>
                                                                <path
                                                                    d="m422.673 61.975v25.159h-27.346v-25.159c0-8.751-7.089-15.84-15.84-15.84h27.346c8.751 0 15.84 7.089 15.84 15.84z"
                                                                    fill="#678d98" data-original="#678d98"></path>
                                                                <path
                                                                    d="m255.997 145.872h-181.474l34.513 326.562c2.377 22.493 21.347 39.564 43.965 39.564h102.996 102.996c22.618 0 41.588-17.071 43.965-39.564l34.513-326.562z"
                                                                    fill="#7ca1b1" data-original="#7ca1b1" class="">
                                                                </path>
                                                                <path
                                                                    d="m437.472 145.873-34.509 326.558c-2.377 22.498-21.351 39.568-43.975 39.568h-29.997c22.624 0 41.587-17.07 43.965-39.568l34.52-326.558z"
                                                                    fill="#678d98" data-original="#678d98"></path>
                                                                <path
                                                                    d="m445.851 148.251h-379.709c-5.006 0-9.065-4.058-9.065-9.065v-45.372c0-5.006 4.058-9.065 9.065-9.065h379.709c5.006 0 9.065 4.058 9.065 9.065v45.372c0 5.006-4.058 9.065-9.065 9.065z"
                                                                    fill="#537983" data-original="#537983"></path>
                                                                <path
                                                                    d="m454.921 93.811v45.374c0 5.007-4.06 9.067-9.066 9.067h-26.105c5.007 0 9.066-4.06 9.066-9.067v-45.374c0-5.007-4.06-9.056-9.066-9.056h26.105c5.006 0 9.066 4.049 9.066 9.056z"
                                                                    fill="#426970" data-original="#426970"></path>
                                                                <g>
                                                                    <g>
                                                                        <g>
                                                                            <path
                                                                                d="m182.678 472.456c-3.877 0-7.162-2.985-7.469-6.917l-21.25-272.041c-.323-4.129 2.763-7.739 6.893-8.061 4.133-.317 7.738 2.764 8.061 6.893l21.25 272.041c.323 4.129-2.763 7.739-6.893 8.061-.198.016-.396.024-.592.024z"
                                                                                fill="#426970" data-original="#426970">
                                                                            </path>
                                                                        </g>
                                                                        <g>
                                                                            <path
                                                                                d="m329.316 472.456c-.195 0-.393-.008-.592-.023-4.13-.322-7.216-3.932-6.894-8.061l21.25-272.041c.323-4.129 3.901-7.22 8.062-6.893 4.13.322 7.216 3.932 6.894 8.061l-21.25 272.041c-.308 3.93-3.593 6.916-7.47 6.916z"
                                                                                fill="#426970" data-original="#426970">
                                                                            </path>
                                                                        </g>
                                                                    </g>
                                                                    <g>
                                                                        <path
                                                                            d="m255.997 472.455c-4.142 0-7.5-3.358-7.5-7.5v-272.041c0-4.142 3.358-7.5 7.5-7.5s7.5 3.358 7.5 7.5v272.041c0 4.142-3.358 7.5-7.5 7.5z"
                                                                            fill="#426970" data-original="#426970"></path>
                                                                    </g>
                                                                </g>
                                                            </g>
                                                        </g>
                                                    </svg></a>
                                            </td>
                                        @else
                                            <td class="text-center "><span
                                                    style="font-size: 13px;
                                            background: #223d7a;
                                            padding: 3px 5px;
                                            border-radius: 3px;
                                            color:#fff">Admin</span>
                                            </td>
                                            </td>
                                            <td class="text-center">
                                                <a href="{{ url('edituser') . '/' . $user->id }}" class="me-3"><svg
                                                        xmlns="http://www.w3.org/2000/svg" version="1.1"
                                                        xmlns:xlink="http://www.w3.org/1999/xlink"
                                                        xmlns:svgjs="http://svgjs.com/svgjs" width="20"
                                                        height="20" x="0" y="0" viewBox="0 0 24 24"
                                                        style="enable-background:new 0 0 512 512" xml:space="preserve"
                                                        class="">
                                                        <g>
                                                            <path
                                                                d="m17 24h-14c-1.654 0-3-1.346-3-3v-14c0-1.654 1.346-3 3-3h8c.553 0 1 .448 1 1s-.447 1-1 1h-8c-.552 0-1 .449-1 1v14c0 .551.448 1 1 1h14c.552 0 1-.449 1-1v-8c0-.552.447-1 1-1s1 .448 1 1v8c0 1.654-1.346 3-3 3z"
                                                                fill="#607d8b" data-original="#607d8b" class="">
                                                            </path>
                                                            <path
                                                                d="m17.288 3.177-7.912 7.912c-.07.07-.117.159-.137.255l-.707 3.536c-.033.164.018.334.137.452.095.095.223.146.354.146l.098-.01 3.535-.707c.098-.019.186-.067.256-.137l7.912-7.912z"
                                                                fill="#42a5f5" data-original="#42a5f5"></path>
                                                            <path
                                                                d="m23.268.732c-.975-.975-2.561-.975-3.535 0l-1.384 1.384 3.535 3.535 1.384-1.384c.472-.471.732-1.099.732-1.767s-.26-1.296-.732-1.768z"
                                                                fill="#42a5f5" data-original="#42a5f5"></path>
                                                            <path
                                                                d="m19 12c-.553 0-1 .448-1 1v8c0 .551-.448 1-1 1h-14c-.276 0-.526-.112-.707-.293l-1.413 1.413c.543.544 1.293.88 2.12.88h14c1.654 0 3-1.346 3-3v-8c0-.553-.447-1-1-1z"
                                                                fill="#546d79" data-original="#546d79" class="">
                                                            </path>
                                                            <g fill="#3990d5">
                                                                <path
                                                                    d="m19.056 4.944-10.387 10.387c.095.095.223.146.354.146l.098-.01 3.535-.707c.098-.019.186-.067.256-.137l7.912-7.912z"
                                                                    fill="#3990d5" data-original="#3990d5"></path>
                                                                <path
                                                                    d="m23.268.732-3.151 3.151 1.768 1.768 1.384-1.384c.471-.471.731-1.099.731-1.767s-.26-1.296-.732-1.768z"
                                                                    fill="#3990d5" data-original="#3990d5"></path>
                                                            </g>
                                                        </g>
                                                    </svg></a>
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-3">
            <div class="card bg-yellow-100 border-0 shadow ">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h2 class="fs-2 fw-bold mb-0">{{ isset($edituser->id) ? 'Update User' : 'Add User' }}</h2>
                        </div>
                    </div>
                </div>
                <div class="card-body p-4">
                    <form action="{{ isset($edituser->id) ? url('updateuser') . '/' . $edituser->id : url('add_user') }}"
                        method="post">
                        @csrf
                        <input type="text" class="form-control mb-3" placeholder="User Name" name="name"
                            required="" value="{{ isset($edituser->id) ? $edituser->name : '' }}" autocomplete="off">
                        <input type="email" class="form-control mb-3" placeholder="User Email" name="email"
                            required="" value="{{ isset($edituser->id) ? $edituser->email : '' }}" autocomplete="off">

                            <input type="text" class="form-control mb-3" placeholder="Designation" name="designation"
                            required="" value="{{ isset($edituser->id) ? $edituser->designation : '' }}" autocomplete="off">

                            <select class="form-select mb-3" aria-label="Default select example" name="department">
                                <option>Select Department</option>
                                <option value="HR" {{isset($edituser->id) && $edituser->department == 'HR'? 'Selected' : '' }}>HR</option>
                                <option value="Sales" {{isset($edituser->id) && $edituser->department == 'Sales'? 'Selected' : '' }}>Sales</option>
                                <option value="Finance" {{isset($edituser->id) && $edituser->department == 'Finance'? 'Selected' : '' }}>Finance</option>
                                <option value="Graphics" {{isset($edituser->id) && $edituser->department == 'Graphics'? 'Selected' : '' }}>Graphics</option>
                                <option value="Management" {{isset($edituser->id) && $edituser->department == 'Management'? 'Selected' : '' }}>Management</option>
                                <option value="Web Designer" {{isset($edituser->id) && $edituser->department == 'Web Designer'? 'Selected' : '' }}>Web Designer</option>
                                <option value="Web Development" {{isset($edituser->id) && $edituser->department == 'Web Development'? 'Selected' : '' }}>Web Development</option>
                                <option value="Digital Marketing" {{isset($edituser->id) && $edituser->department == 'Digital Marketing'? 'Selected' : '' }}>Digital Marketing</option>
                              </select>
                        @if (!isset($edituser->id))
                            <input type="password" class="form-control mb-3" placeholder="User Password" name="password"
                                required="" autocomplete="off">
                        @endif
                        <button class="btn btn-secondary text-dark btn-sm me-2"
                            type="submit">{{ isset($edituser->id) ? 'Update User' : 'Add User' }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection