<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MainController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/sheets/{folder_id}/{folder_name}', [MainController::class, 'allsheets']);
Route::get('/sheets', [MainController::class, 'allsheetsusers']);
Route::get('/reservation', function () {
    return view('admin.index');
});
Route::get('/users', function () {
    return view('admin.users');
});
Route::get('/spreadsheets/{id}/{name}', [MainController::class, 'show_sheet']);
Route::get('/users', [MainController::class, 'users']);
Route::get('/folders', [MainController::class, 'folders']);
Route::post('/share_access', [MainController::class, 'share_access']);
Route::post('/check_share_access', [MainController::class, 'check_share_access']);

Route::get('/sign-in', [MainController::class, 'login']);
Route::post('login_check', [MainController::class, 'login_check']);
Route::post('otp_check', [MainController::class, 'otp_check']);
Route::get('/logout', [MainController::class, 'logout']);
Route::post('add_user', [MainController::class, 'add_user']);
Route::get('remove_user/{id}', [MainController::class, 'remove_user']);
Route::get('edituser/{id}', [MainController::class, 'edituser']);
Route::post('updateuser/{id}', [MainController::class, 'updateuser']);

Route::get('/editfolders/{id}', [MainController::class, 'editfolders']);
Route::post('addfolders', [MainController::class, 'addfolders']);
Route::post('updatefolder/{id}', [MainController::class, 'updatefolder']);
Route::get('deletefolders/{id}', [MainController::class, 'deletefolders']);
Route::post('iurtifjfnvmncxlkj', [MainController::class, 'iurtifjfnvmncxlkj']);
Route::post('ncvbxcvmcbxvmcbxvm', [MainController::class, 'ncvbxcvmcbxvmcbxvm']);
Route::get('ips', [MainController::class, 'ips']);
Route::get('userdisabled', [MainController::class, 'userdisabled']);
Route::get('send-sms', [MainController::class, 'send_sms']);
Route::get('jdf', [MainController::class, 'jdf']);
Route::get('login-histories', [MainController::class, 'login_histories']);
Route::post('logout_check_time', [MainController::class, 'logout_check_time']);
Route::post('update-deploy-url', [MainController::class, 'update_deploy_url']);
Route::post('remove-access', [MainController::class, 'remove_access']);
Route::get('drive-configuration', [MainController::class, 'drive_configuration']);

Route::get('/', function () {
    return view('admin.drivetest');
});
// Clear application cache:
Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    return 'Application cache has been cleared';
});

//Clear route cache:
Route::get('/route-cache', function() {
	Artisan::call('route:cache');
    return 'Routes cache has been cleared';
});

//Clear config cache:
Route::get('/config-cache', function() {
 	Artisan::call('config:cache');
 	return 'Config cache has been cleared';
}); 

// Clear view cache:
Route::get('/view-clear', function() {
    Artisan::call('view:clear');
    return 'View cache has been cleared';
});