<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\user_access;
use App\Models\Folder;
use App\Models\ip_restriction;
use App\Models\Login_history;
use App\Models\Deploy;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Date;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Crypt;
// use Illuminate\Support\Facades\Str;
use Illuminate\Support\Str;

class MainController extends Controller
{
    public function login()
    {
        return view('admin.sign-in');
    }

    public function login_check(Request $request)
    {
        $this->validate($request, [
            'email' => 'required',
            'password' => 'required',
        ]);

        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            $userids = User::firstWhere('email', $request['email']);
            if ($userids->status == '0') {
                    Auth::logout();
                    $request->session()->invalidate();
                    $request->session()->regenerateToken();
                    Session::put('message', 'Disabled User!!!');
                    return redirect(url('sign-in'));
                }
                                Session::put('userid', $userids->id);
                Session::put('user_department', $userids->department);
                                date_default_timezone_set('Asia/Kolkata');

                $log_history = new Login_history;

                $log_history->user_id = $userids->id;
                Cache::put('useridsss', $userids->id);

                $log_history->last_login = date('h:i A', time());
                Cache::put('last_loginsss', date('h:i A', time()));

                $log_history->date = date('d M, Y', time());
                Cache::put('datesss', date('d M, Y', time()));
            
                $log_history->save();
                return redirect(url('/folders'));
            // if ($userids->otp_varification == 'done') {
            //     if ($userids->status == '0') {
            //         Auth::logout();
            //         $request->session()->invalidate();
            //         $request->session()->regenerateToken();
            //         Session::put('message', 'Disabled User!!!');
            //         return redirect(url('sign-in'));
            //     }
            //     Session::put('userid', $userids->id);
            //     Session::put('user_department', $userids->department);

            //     date_default_timezone_set('Asia/Kolkata');

            //     $log_history = new Login_history;

            //     $log_history->user_id = $userids->id;
            //     Cache::put('useridsss', $userids->id);

            //     $log_history->last_login = date('h:i A', time());
            //     Cache::put('last_loginsss', date('h:i A', time()));

            //     $log_history->date = date('d M, Y', time());
            //     Cache::put('datesss', date('d M, Y', time()));

            //     $log_history->save();
            //     return redirect(url('/folders'));
            // } else {
            //     Session::put('useridforotp', $userids->id);
            //     return redirect(url('sign-in'));
            // }
        } else {
            Session::flash('message', 'wrong Credentials');
            return redirect(url('sign-in'));
        }
    }

    public function login_histories(Request $request)
    {
        $login_histories = DB::table('login_histories')->leftJoin('users', 'users.id', '=', 'login_histories.user_id')->get();

        // $login_histories = Login_history::leftJoin('posts', 'users.id', '=', 'posts.user_id')->get();
        return view("admin.login-histories", compact('login_histories'));
    }
    public function logout_check_time(Request $request)
    {
        $cach_uid = cache('useridsss');
        $cach_lls = cache('last_loginsss');
        $cach_dates = cache('datesss');
        date_default_timezone_set('Asia/Kolkata');
        $updatell = Login_history::where('user_id', $cach_uid)->where('last_login', $cach_lls)->where('date', $cach_dates)->first();
        $updatell->last_logout = date('h:i A', time());
        $updatell->update();
    }
    public function otp_check(Request $request)
    {
        $this->validate($request, [
            'otp' => ['required', 'integer', 'min:5']
        ]);
        $id = session('useridforotp');
        $dsad = User::firstWhere('id', $id);
        // echo $request->otp;
        if ($dsad->otp_varification == $request->otp) {
            $otp =  User::find($id);
            $otp->otp_varification = 'done';
            $otp->update();
            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();
            Session::flash('otpmessage', 'OTP Verified Successfully.');
            return redirect(url('sign-in'));
        } else {
            Session::flash('message', 'Wrong OTP.');
            return redirect(url('sign-in'));
        }
    }
    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect(url('sign-in'));
    }
    public function userdisabled(Request $request)
    {
        if (session('userid') != 1) {
            $xxa =  User::find(session('userid'));
            $xxa->status = '0';
            $xxa->update();
        }
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect(url('sign-in'));
    }
    public function allsheets(Request $request, $folder_id, $folder_name)
    {
        $usersid = session('userid');
        if (session('userid') == 1) {
            $users =  User::all();
            return view("admin.allsheets", compact('users', 'folder_id', 'folder_name'));
        } else {
            $users =  user_access::select('*')->where('user_id', $usersid)->get();
            return view("admin.allsheets", compact('users'));
        }
    }
    public function allsheetsusers(Request $request)
    {
        $usersid = session('userid');
        if (session('userid') != 1) {
            $users =  user_access::select('*')->where('user_id', $usersid)->get();
            return view("admin.allsheets", compact('users'));
        }
    }

    public function folders(Request $request)
    {
        if (session('userid') == 1) {
            $folders =  Folder::all();
            return view("admin.folders", compact('folders'));
        } else {
            return redirect(url('sheets'));
        }
    }
    public function iurtifjfnvmncxlkj(Request $request)
    {
        if ($request->jhncxkdhfk != 1) {
            $check = User::select('status')->where('id', $request->jhncxkdhfk)->first();
            if ($check->status == 1) {
                $status =  User::find($request->jhncxkdhfk);
                $status->status = '0';
            } else {
                $status =  User::find($request->jhncxkdhfk);
                $status->status = '1';
            }
            $status->update();
            return;
        }
    }
    public function addfolders(Request $request)
    {
        $contact = new Folder;
        $contact->folder_name = $request->input('folder_name');
        $contact->folder_id = $request->input('folder_id');
        $contact->save();
        return redirect(url('/folders'));
    }
    public function deletefolders(Request $request, $id)
    {
        Folder::find($id)->delete();
        return redirect(url('/folders'));
    }
    public function editfolders(Request $request, $id)
    {
        $folders =  Folder::all();
        $editfolders =  Folder::find($id);
        return view("admin.folders", compact('folders', 'editfolders'));
    }
    public function updatefolder(Request $request, $id)
    {
        $updatefolder =  Folder::find($id);
        $updatefolder->folder_name = $request->input('folder_name');
        $updatefolder->folder_id = $request->input('folder_id');
        $updatefolder->update();
        return redirect(url('/folders'));
    }
    public function show_sheet(Request $request, $id, $name)
    {
        if (session('userid') == 1) {
            $cid = $id;
        } else {
            $cid = Crypt::decryptString($id);
        }
        $role = user_access::select('role')->where('file_id', $cid)->where('user_id', session('userid'))->first();
        if (session('userid') == 1) {
            Session::put('role', 'admin');
            // echo session('userid');
        } else {
            Session::put('role', $role->role);
        }
        // echo session('role');
        $users =  User::all();
        return view("admin.spreadsheets", compact('id', 'users', 'role', 'name'));
    }
    public function users(Request $request)
    {
        if (session('userid') == 1) {
            $users =  User::all();
            $ips =  ip_restriction::first();
            return view('admin.users', compact('users'));
        } else {
            return abort(404);
        }
    }
    public function ips(Request $request)
    {
        if (session('userid') == 1) {
            $ips =  ip_restriction::first();
            return view('admin.ips', compact('ips'));
        } else {
            return abort(404);
        }
    }

    public function share_access(Request $request)
    {
        $file_id = $request['file_id'];
        $file_name = $request['file_name'];
        $role = $request['role'];
        $user_id = $request['user_id'];
        echo $file_name;
        $check = user_access::where('file_id', $file_id)->where('user_id', $user_id)->first();
        if ($check) {
            $check->file_name = $file_name;
            $check->role = $role;
            $check->update();
            echo 'updated';
        } else {
            $us = new user_access;
            $us->user_id = $user_id;
            $us->file_id = $file_id;
            $us->file_name = $file_name;
            $us->role = $role;
            $us->save();
            echo 'inserted';
        }
    }
    // Harsh@25
    public function check_share_access(Request $request)
    {
        $file_id = $request['file_id'];
        $check = user_access::select('user_id', 'role')->where('file_id', $file_id)->get()->toArray();
        return $check;
    }
    public function add_user(Request $request)
    {
        $contact = new User;
        $contact->name = $request->input('name');
        $contact->email = $request->input('email');
        $contact->password = $request->input('password');
        $contact->remember_token =  Str::random(60);
        $contact->email_verified_at = now()->timestamp;
        $contact->otp_varification = rand(11111, 99999);
        $contact->designation = $request->input('designation');
        $contact->department = $request->input('department');
        $contact->save();
        // $dsad = User::firstWhere('email', $request->input('email'));
        Session::flash('usersave', "User Added");
        return redirect()->back();
        // $message = "Email: $dsad->otp_varification, OTP: $request->input('email').";
        // if (Send_OTP($message)) {
        //     Session::flash('usersave', "User Added");
        //     return redirect()->back();
        // }
    }
    public function edituser(Request $request, $id)
    {
        $users =  User::all();
        $edituser =  User::find($id);
        $ips =  ip_restriction::first();
        return view("admin.users", compact('users', 'edituser', 'ips'));
    }
    public function updateuser(Request $request, $id)
    {
        $updatefolder =  User::find($id);
        $updatefolder->name = $request->input('name');
        $updatefolder->email = $request->input('email');
        $updatefolder->designation = $request->input('designation');
        $updatefolder->department = $request->input('department');
        $updatefolder->update();
        return redirect(url('users'));
    }
    public function remove_user(Request $request, $id)
    {
        User::find($id)->delete();
        return redirect()->back();
    }
    public function ncvbxcvmcbxvmcbxvm(Request $request)
    {
        $ip_restriction =  ip_restriction::find(1);
        $ip_restriction->address = $request->input('add_ips');
        $ip_restriction->update();
        return redirect()->back();
    }

    public function drive_configuration(Request $request)
    {
        $deploy =  Deploy::find(1);
           $deploy = $deploy->deploys_url;
        return view("admin.drive-configuration", compact('deploy'));
    }
    public function update_deploy_url(Request $request)
    {
        $deploy =  Deploy::find(1);
            $deploy->deploys_otp;
        if (!isset($request->deploys_otp)) {
            $message = "You Really want to Change The Deploy URL?? if yes then share the CODE : $deploy->deploys_otp.";
            if (Send_OTP($message)) {
                Session::flash('deploys_url', $request->input('deploys_url'));
                return redirect()->back();
            }
        }else{
            if($deploy->deploys_otp == $request->input('deploys_otp')){
                $deploy->deploys_url = $request->input('deploys_url');
                $deploy->deploys_otp = 'DEPLOY-'.rand(11111, 99999);
                $deploy->update();
                Session::flash('url_updated', 'Deploy URL Updated');
                return redirect(url('drive-configuration'));
            }else{
                Session::flash('url_updated', 'Wrong OTP.');
                return redirect(url('drive-configuration'));
            }
        }
    }
    public function remove_access(Request $request){
        user_access::where('user_id', $request->input('user_id'))->where('file_id', $request->input('file_id'))->delete();
        echo 'Deleted';
    }
}
