@extends('admin.main')
@section('content')

          <div class="row">
            <div class="col-12 mb-4">
                <div class="card border-0 shadow">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col">
                                <h2 class="fs-5 fw-bold mb-0">Career</h2>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="border-bottom" scope="col">ID</th>
                                <th class="border-bottom" scope="col">Full Name</th>
                                <th class="border-bottom" scope="col">Email</th>
                                <th class="border-bottom" scope="col">Phone</th>
                                <th class="border-bottom" scope="col">Job Profile</th>
                                <th class="border-bottom" scope="col">Expected Salary</th>
                                <th class="border-bottom" scope="col">Work Experience</th>
                                <th class="border-bottom" scope="col">Resume (CV)</th>
                                <th class="border-bottom" scope="col">Message</th>
                            </tr>
                            </thead>
                            <tbody>
                                {{-- {{print_r($careers)}} --}}
                                @foreach ($careers as $career)

                                <tr>
                                    <th class="text-gray-900" scope="row">
                                        {{$career->id}}
                                    </th>
                                    <td class="fw-bolder text-gray-500">
                                        {{$career->full_name}}
                                    </td>
                                    <td class="fw-bolder text-gray-500">
                                        {{$career->email}}
                                    </td>
                                    <td class="fw-bolder text-gray-500">
                                        {{$career->phone}}
                                    </td>
                                    <td class="fw-bolder text-gray-500">
                                        {{$career->job_profile}}
                                    </td>
                                    <td class="fw-bolder text-gray-500">
                                        {{$career->exp_salary}}
                                    </td>
                                    <td class="fw-bolder text-gray-500">
                                        {{$career->work_exp}}
                                    </td>
                                    <td class="fw-bolder text-gray-500">
                                        <a class="btn btn-secondary text-dark btn-sm" target="_blank" href="{{asset('uploads/'.$career->cv)}}"><svg class="icon icon-xxs me-2" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M10 12a2 2 0 100-4 2 2 0 000 4z"></path><path fill-rule="evenodd" d="M.458 10C1.732 5.943 5.522 3 10 3s8.268 2.943 9.542 7c-1.274 4.057-5.064 7-9.542 7S1.732 14.057.458 10zM14 10a4 4 0 11-8 0 4 4 0 018 0z" clip-rule="evenodd"></path></svg> View</a>
                                        
                                    </td>
                                    <td class="fw-bolder text-gray-500" style="">
                                        <div style="white-space: initial; width:300px">
                                            {{$career->message}}
                                        </div>
                                        
                                        
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
                  </div>
          @endsection
          