@extends('admin.main')
@section('content')

          <div class="row">
                    @foreach ($portfolios as $portfolio)
                    
                    <div class="col-lg-3 col-md-4 col-12 mb-4" id="card{{$portfolio->id}}">
                        <div class="card border-0 shadow">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h2 class="fs-5 fw-bold mb-0">{{$portfolio->heading}}</h2>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                              <div class="col-12">
                                  <img src="{{asset('uploads/'.$portfolio->image)}}" alt="" class="mb-3 w-100 rounded">
                                  <form action="{{url('dashboard/update-portfolio')}}/{{$portfolio->id}}" method="post" enctype="multipart/form-data">
                                      @csrf
                                      <input type="text" class="form-control mb-3" style="font-size: 25px; font-weight:500" placeholder="Heading" name="heading" value="{{$portfolio->heading}}">
                                      <input type="file" class="form-control mb-3 mt-3" name="image">
                                      <div class="text-end">
                                      <button class="btn btn-secondary text-dark btn-sm me-2" type="submit">Update Section</button>
                                  </div>
                                  </form>
                              </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                    @foreach ($video as $videos)
                    
                    <div class="col-lg-4 col-md-6 col-12 mb-4" id="#v">
                        <div class="card border-0 shadow">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                            <form action="{{url('dashboard/video-update')}}/{{$videos->id}}" class="mt-4" method="POST" id="bannerUpload" enctype="multipart/form-data">
                                                    @csrf
                                                <label for="video{{$videos->id}}" class="btn btn-secondary text-dark btn-sm me-2">Change Video</label>
                                                <input type="file" id="video{{$videos->id}}" class="d-none" name="video" accept="video/mp4,video/x-m4v,video/*"/>
                                                <span class="text-danger">{{$errors->first('banner_video')}}</span>
                                            </form>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <video class="mainvideo" oncontextmenu="return false;"autoplay muted playsinline loop poster="{{asset('uploads/images/poster.png')}}" style="width: 100%">
                                    <source src="{{asset('uploads/'.$videos->video)}}" type="video/mp4">
                                </video>
                            </div>
                        </div>
                    </div>
                    @endforeach
                  </div>
          @endsection
          